#!/bin/csh

for file in $(cat resulting_fileNumber.csv)
do

bruk2pipe -verb -in ../rawFID/$file/ser \
  -bad 0.0 -ext -aswap -AMX -decim 2346.66666666667 -dspfvs 20 -grpdly 67.9861602783203  \
  -xN              1024  -yN                96  \
  -xT               512  -yT                48  \
  -xMODE            DQD  -yMODE  Echo-AntiEcho  \
  -xSW         8522.727  -ySW         6038.647  \
  -xOBS         600.133  -yOBS         150.913  \
  -xCAR           4.700  -yCAR          70.733  \
  -xLAB              1H  -yLAB             13C  \
  -ndim               2  -aq2D         Complex  \
| nmrPipe -fn MULT -c 2.44141e-01 \
  -out ../fid/$file.fid -ov

echo "'$file.fid' was created"
echo ""

sleep 5

done
