#!/bin/csh

for file in $(cat resulting_fileNumber.csv)

do

echo "Processing '${file}.fid':"

numLine=$(grep -xn $file resulting_fileNumber.csv | grep -Eo '^[^:]+')
echo "Run $numLine"

linep=$(echo "${numLine}p")
p0=$(sed -n $linep p0.csv)
echo "p0 = $p0"

nmrPipe -in ../fid/$file.fid \
| nmrPipe -fn SP -off 0.5 -end 1 -pow 2 -c 1 \
| nmrPipe -fn ZF -auto \
| nmrPipe -fn FT -auto \
| nmrPipe -fn PS -p0 -10 -p1 0 -di \
| nmrPipe -fn TP  \
| nmrPipe -fn LP -fb  \
| nmrPipe -fn SP -off 0.5 -end 1 -pow 2 -c 1 \
| nmrPipe -fn ZF -size 1024 \
| nmrPipe -fn FT -auto \
| nmrPipe -fn PS -p0 87 -p1 0 -di \
| nmrPipe -fn POLY -auto \
| nmrPipe -fn TP \
| nmrPipe -fn POLY -auto\
| nmrPipe -out ../ft/"$file".ft2 -ov -verb \

echo "'${file}.ft2' was created."
echo ""

done
